/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.impl;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.systems.localization.Language;
import Krasnodar.rockstarnew.systems.localization.Localizator;
import Krasnodar.rockstarnew.systems.modules.Module;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.modules.other.Sounds;
import Krasnodar.rockstarnew.systems.modules.modules.visuals.MenuModule;
import Krasnodar.rockstarnew.systems.notifications.NotificationType;
import Krasnodar.rockstarnew.systems.setting.Setting;
import Krasnodar.rockstarnew.utility.animation.base.Animation;
import Krasnodar.rockstarnew.utility.animation.base.Easing;
import Krasnodar.rockstarnew.utility.game.TextUtility;
import Krasnodar.rockstarnew.utility.sounds.ClientSounds;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public abstract class BaseModule
implements Module {
    private final ModuleInfo info = this.getClass().getAnnotation(ModuleInfo.class);
    private int key;
    private ModuleCategory category;
    private boolean enabled;
    private boolean hidden;
    private String name;
    private List<Setting> settings = new ArrayList<Setting>();
    private final Animation keybindsAnimation = new Animation(300L, 0.0f, Easing.FIGMA_EASE_IN_OUT);

    public BaseModule() {
        this.name = this.info.name();
        this.category = this.info.category();
        this.key = this.info.key();
    }

    @Override
    public void toggle() {
        this.setEnabled(!this.enabled, false);
    }

    @Override
    public void onEnable() {
    }

    @Override
    public void onDisable() {
    }

    @Override
    public void tick() {
    }

    @Override
    public void disable() {
        this.setEnabled(false, false);
    }

    @Override
    public void enable() {
        this.setEnabled(true, false);
    }

    @Override
    public void setEnabled(boolean newState, boolean silent) {
        if (this.enabled != newState) {
            this.enabled = newState;
            if (!(this instanceof MenuModule) && Rockstar.getInstance().getModuleManager().getModule(Sounds.class).isEnabled() && !silent) {
                ClientSounds.MODULE.play(Rockstar.getInstance().getModuleManager().getModule(Sounds.class).getVolume().getCurrentValue(), this.enabled ? 1.1f : 1.0f);
            }
            if (this.enabled) {
                Rockstar.getInstance().getEventManager().subscribe(this);
                if (!silent) {
                    Rockstar.getInstance().getNotificationManager().addNotification(NotificationType.SUCCESS, this.name.replace(" ", "") + " " + Localizator.translate("enabled") + (Localizator.getCurrentLanguage() == Language.RU_RU ? TextUtility.makeGender(this.name) : ""));
                }
                this.onEnable();
            } else {
                Rockstar.getInstance().getEventManager().unsubscribe(this);
                if (!silent) {
                    Rockstar.getInstance().getNotificationManager().addNotification(NotificationType.ERROR, this.name.replace(" ", "") + " " + Localizator.translate("disabled") + (Localizator.getCurrentLanguage() == Language.RU_RU ? TextUtility.makeGender(this.name) : ""));
                }
                this.onDisable();
            }
        }
    }

    public String getSettingName(String key) {
        return "modules.settings." + this.getName().toLowerCase().replace(" ", "_") + "." + key;
    }

    @Override
    @Generated
    public ModuleInfo getInfo() {
        return this.info;
    }

    @Override
    @Generated
    public int getKey() {
        return this.key;
    }

    @Override
    @Generated
    public ModuleCategory getCategory() {
        return this.category;
    }

    @Override
    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @Generated
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public List<Setting> getSettings() {
        return this.settings;
    }

    @Override
    @Generated
    public Animation getKeybindsAnimation() {
        return this.keybindsAnimation;
    }

    @Override
    @Generated
    public void setKey(int key) {
        this.key = key;
    }

    @Generated
    public void setCategory(ModuleCategory category) {
        this.category = category;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSettings(List<Setting> settings) {
        this.settings = settings;
    }
}

